const { Schema, model } = require("mongoose");

const userSchema = new Schema(
  {
    firstName: {
      type: String,
      trim: true,
    },
    lastName: {
      type: String,
      trim: true,
    },
    username: {
      type: String,
      required: true,
      unique: true,
      trim: true,
      lowercase: true,
    },
    email: {
      type: String,
      required: true,
      unique: true,
      lowercase: true,
    },
    password: {
      type: String,
      required: true,
    },
    shortBio: {
      type: String,
      maxlength: 300,
    },
    occupation: {
      type: String,
    },
    favouriteGenres: [
      {
        type: Schema.Types.ObjectId,
        ref: "genre", // references Genre model
      },
    ],
    role: {
      type: String,
      enum: ["user", "admin", "blogger"],
      default: "user",
    },
    isVerified: {
      type: Boolean,
      default: false,
    },
    pfp: {
      type: String, // will store image URL or file path
      default: null,
    },
    // 🔑 ADD THESE FIELDS FOR FORGOT PASSWORD
    resetPasswordToken: { type: String },
    resetPasswordExpires: { type: Date },
  },
  { timestamps: true }
);

const User = model("user", userSchema);
module.exports = User;
