// models/ModerationLog.js
const { Schema, model } = require("mongoose");

const moderationLogSchema = new Schema(
  {
    action: {
      type: String,
      required: true,
      enum: [
        "DELETE_USER",
        "USER_ACTIVE",
        "USER_UNACTIVE",
        "DELETE_GENRE",
        "DELETE_BLOG",
        "DELETE_STORY",
        "DELETE_COMMENT",
        "BAN_USER",
        "UNBAN_USER",
        "FLAG_CONTENT",
        "APPROVE_CONTENT",
      ],
    },
    targetType: {
      type: String,
      required: true,
      enum: ["blog", "story", "comment", "user", "genre"],
    },
    targetId: {
      type: Schema.Types.ObjectId,
      required: true,
    },
    performedBy: {
      type: Schema.Types.ObjectId,
      ref: "user",
      required: true,
    },
    reason: {
      type: String,
      maxlength: 500,
    },
    metadata: {
      type: Object, // extra info if needed
    },
  },
  { timestamps: true }
);

moderationLogSchema.index({ targetType: 1, targetId: 1 });
moderationLogSchema.index({ performedBy: 1, createdAt: -1 });

module.exports = model("moderationLog", moderationLogSchema);
