// models/Genre.js
const { Schema, model } = require("mongoose");

const genreSchema = new Schema(
  {
    name: {
      type: String,
      required: true,
      unique: true,
      trim: true,
    },
    slug: {
      type: String,
      required: true,
      unique: true,
      lowercase: true,
      trim: true,
    },
    description: {
      type: String,
      default: null,
      maxlength: 1000,
    },
    content: {
      type: String,
      default: null,
    }, // rich text or markdown
    image: {
      type: String,
      default: null,
    }, // external URL or storage path
    isActive: {
      type: Boolean,
      default: true,
    },
    isDeleted: {
      type: Boolean,
      default: false,
    }, // soft delete
    meta: {
      createdBy: {
        type: Schema.Types.ObjectId,
        ref: "user",
      }, // optional
    },
  },
  { timestamps: true }
);

module.exports = model("genre", genreSchema);
