const asyncHandler = require("express-async-handler");

// Middleware to check if user has blogger or admin role
const isBlogger = asyncHandler(async (req, res, next) => {
  if (!req.user) {
    res.status(401);
    throw new Error("Not authorized, please login");
  }

  const allowedRoles = ["blogger", "admin"];

  if (!allowedRoles.includes(req.user.role)) {
    res.status(403);
    throw new Error(
      "Access denied. Only bloggers and admins can perform this action"
    );
  }

  next();
});

// Middleware to check if user has admin role
const isAdmin = asyncHandler(async (req, res, next) => {
  if (!req.user) {
    res.status(401);
    throw new Error("Not authorized, please login");
  }

  if (req.user.role !== "admin") {
    res.status(403);
    throw new Error("Access denied. Only admins can perform this action");
  }

  next();
});

module.exports = { isBlogger, isAdmin };
