const express = require("express");
const app = express();
const bodyParser = require("body-parser");
const path = require("path");
const cookieParser = require("cookie-parser");

require("./db");
const authValidator = require("./middleware/authValidator");

// Middleware
app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json());
app.use(cookieParser());

//  Serve uploads folder so images are accessible
app.use("/uploads", express.static(path.join(__dirname, "uploads")));

// API routes
app.use("/api", require("./controller/apiHandler"));

// Auth validator for protected routes
app.use(authValidator());

//  Serve React build
app.use(express.static(path.join(__dirname, "views")));

//  Handle React routing (client-side routes)
app.get("*", (req, res) => {
  res.sendFile(path.join(__dirname, "views", "index.html"));
});

// Start server
const PORT = process.env.PORT || 6871;
app.listen(PORT, () => {
  console.log(`App is live on port: ${PORT}`);
});
