const express = require("express");
const router = express.Router();
const asyncHandler = require("express-async-handler");
const ModerationLog = require("../model/ModerationLog"); // Capitalized for model
const { isAdmin } = require("../middleware/bloggerAuth");
const authValidator = require("../middleware/authValidator");

// ======================================
// FETCH All Moderation Logs (Admin Only)
// ======================================
router.get(
  "/fetch",
  authValidator(),
  isAdmin,
  asyncHandler(async (req, res) => {
    const logs = await ModerationLog.find()
      .populate({
        path: "performedBy",
        select: "username email role pfp firstName lastName",
      })
      .sort({ createdAt: -1 });

    res.status(200).json({
      success: true,
      count: logs.length,
      moderationLog: logs,
    });
  })
);

module.exports = router;
